/*
  the swirly effect on ball carrier.
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary

  one for each team is made and kept around for the whole game because otherwise
  it would take one second to appear when player gets ball, with his way it appears immediately
  (some kind of delay when first starting up particle system)
*/

class UTBRCarrierEffect extends UTEmit_HitEffect;

var repnotify Pawn Holder;
var	ParticleSystem	CarrierEffectTemplates[2];
var repnotify int TeamIndex;


simulated event ReplicatedEvent(name VarName)
{
  if (VarName == 'TeamIndex')
  {
       SetTemplate(CarrierEffectTemplates[TeamIndex]);
  }
   
  if (VarName == 'Holder')
  {
	    if (Holder != none)
	    {
	       AttachTo(Holder, '');
      }
      else
      {
	       DetachFromHolder();
      }
  }
}

simulated function PostBeginPlay()
{
	super.PostBeginPlay();
	
	LifeSpan=0;
}

function SetTeam(int teamNum)
{
   TeamIndex = teamNum; 
   SetTemplate(CarrierEffectTemplates[teamNum]);
   SetHidden(true);
}

simulated function AttachTo(Pawn P, name NewBoneName)
{
	Holder = p;
	SetHidden(false);
	super.AttachTo(p, NewBoneName);
	SetRelativeLocation(vect(0,0,0));
	bForceNetUpdate = True;
	SetOwner(Holder);
    ParticleSystemComponent.SetOwnerNoSee(Holder.IsFirstPerson());     		
}

simulated function DetachFromHolder()
{
	Holder = none;
	SetHidden(true);
	SetBase(none);
    SetOwner(none);	
	bForceNetUpdate = True;		
}

simulated function PawnBaseDied()
{
}

replication
{
    if (Role == ROLE_Authority)
		TeamIndex, Holder;
}

defaultproperties
{ 
   Name="Default__UTBRCarrierEffect"
   ObjectArchetype=UTEmit_HitEffect'UTGame.Default__UTEmit_HitEffect'    
   LifeSpan=0
   CarrierEffectTemplates(0)=ParticleSystem'BombingRunGraphics.Player_Ring_Red'
   CarrierEffectTemplates(1)=ParticleSystem'BombingRunGraphics.Player_Ring_Blue'     
   bDestroyOnSystemFinish=False   
   RemoteRole=ROLE_SimulatedProxy   
   bGameRelevant=True
   bAlwaysRelevant = true;
   TeamIndex=-1
   bUpdateSimulatedPosition = True;   
}
